/* src/bazaar.p/bz-safety-row.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-safety-row.h"



struct _BzSafetyRow
{
  GObject parent_instance;

  BzImportance importance;
  char *title;
  char *subtitle;
  char *icon_name;
};

G_DEFINE_FINAL_TYPE (BzSafetyRow, bz_safety_row, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_IMPORTANCE,
  PROP_TITLE,
  PROP_SUBTITLE,
  PROP_ICON_NAME,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_safety_row_dispose (GObject *object)
{
  BzSafetyRow *self = BZ_SAFETY_ROW (object);

  g_clear_pointer (&self->title, g_free);
  g_clear_pointer (&self->subtitle, g_free);
  g_clear_pointer (&self->icon_name, g_free);

  G_OBJECT_CLASS (bz_safety_row_parent_class)->dispose (object);
}

static void
bz_safety_row_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzSafetyRow *self = BZ_SAFETY_ROW (object);

  switch (prop_id)
    {
    case PROP_IMPORTANCE:
      g_value_set_enum (value, bz_safety_row_get_importance (self));
      break;
    case PROP_TITLE:
      g_value_set_string (value, bz_safety_row_get_title (self));
      break;
    case PROP_SUBTITLE:
      g_value_set_string (value, bz_safety_row_get_subtitle (self));
      break;
    case PROP_ICON_NAME:
      g_value_set_string (value, bz_safety_row_get_icon_name (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_safety_row_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzSafetyRow *self = BZ_SAFETY_ROW (object);

  switch (prop_id)
    {
    case PROP_IMPORTANCE:
      bz_safety_row_set_importance (self, g_value_get_enum (value));
      break;
    case PROP_TITLE:
      bz_safety_row_set_title (self, g_value_get_string (value));
      break;
    case PROP_SUBTITLE:
      bz_safety_row_set_subtitle (self, g_value_get_string (value));
      break;
    case PROP_ICON_NAME:
      bz_safety_row_set_icon_name (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_safety_row_class_init (BzSafetyRowClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_safety_row_set_property;
  object_class->get_property = bz_safety_row_get_property;
  object_class->dispose      = bz_safety_row_dispose;

  props[PROP_IMPORTANCE] =
      g_param_spec_enum (
          "importance",
          NULL, NULL,
          BZ_TYPE_IMPORTANCE, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TITLE] =
      g_param_spec_string (
          "title",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_SUBTITLE] =
      g_param_spec_string (
          "subtitle",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ICON_NAME] =
      g_param_spec_string (
          "icon-name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_safety_row_init (BzSafetyRow *self)
{
}

BzSafetyRow *
bz_safety_row_new (void){
  return g_object_new (BZ_TYPE_SAFETY_ROW, NULL);
}

BzImportance
bz_safety_row_get_importance (BzSafetyRow *self){
  g_return_val_if_fail (BZ_IS_SAFETY_ROW (self), 0);
  return self->importance;
}

const char *
bz_safety_row_get_title (BzSafetyRow *self){
  g_return_val_if_fail (BZ_IS_SAFETY_ROW (self), NULL);
  return self->title;
}

const char *
bz_safety_row_get_subtitle (BzSafetyRow *self){
  g_return_val_if_fail (BZ_IS_SAFETY_ROW (self), NULL);
  return self->subtitle;
}

const char *
bz_safety_row_get_icon_name (BzSafetyRow *self){
  g_return_val_if_fail (BZ_IS_SAFETY_ROW (self), NULL);
  return self->icon_name;
}

void
bz_safety_row_set_importance (BzSafetyRow *self,
    BzImportance importance){
  g_return_if_fail (BZ_IS_SAFETY_ROW (self));

  if (importance == self->importance)
    return;

  self->importance = importance;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_IMPORTANCE]);
}

void
bz_safety_row_set_title (BzSafetyRow *self,
    const char *title){
  g_return_if_fail (BZ_IS_SAFETY_ROW (self));

  if (title == self->title || (title != NULL && self->title != NULL && g_strcmp0(title, self->title) == 0))
    return;

  g_clear_pointer (&self->title, g_free);
  if (title != NULL)
    self->title = g_strdup (title);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TITLE]);
}

void
bz_safety_row_set_subtitle (BzSafetyRow *self,
    const char *subtitle){
  g_return_if_fail (BZ_IS_SAFETY_ROW (self));

  if (subtitle == self->subtitle || (subtitle != NULL && self->subtitle != NULL && g_strcmp0(subtitle, self->subtitle) == 0))
    return;

  g_clear_pointer (&self->subtitle, g_free);
  if (subtitle != NULL)
    self->subtitle = g_strdup (subtitle);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_SUBTITLE]);
}

void
bz_safety_row_set_icon_name (BzSafetyRow *self,
    const char *icon_name){
  g_return_if_fail (BZ_IS_SAFETY_ROW (self));

  if (icon_name == self->icon_name || (icon_name != NULL && self->icon_name != NULL && g_strcmp0(icon_name, self->icon_name) == 0))
    return;

  g_clear_pointer (&self->icon_name, g_free);
  if (icon_name != NULL)
    self->icon_name = g_strdup (icon_name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ICON_NAME]);
}

/* End of src/bazaar.p/bz-safety-row.c */
