/*
 * Copyright (c) 1995 Shunsuke Akiyama.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Shunsuke Akiyama.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Shunsuke Akiyama AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	$Id: eject.c,v 1.2 1995/11/12 10:08:13 shun Exp $
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/ucred.h>
#include <sys/mount.h>
#include <sys/cdio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>

void usage(void);
int check_device(char *, char *);
int unmount_fs(char *, char *);
int eject(char *);

char *program = "eject";

int fflag;

main(argc, argv)
    int argc;
    char *argv[];
{
    int ch;
    int sts;
    char device[256], name[256];
    char err[256];

    fflag = 0;

    while ((ch = getopt(argc, argv, "f?")) != EOF) {
	switch (ch) {
	  case 'f' :
	    fflag = 1;
	    break;
	  case '?' :
	  default :
	    usage();
	}
    }
    argc -= optind;
    argv += optind;

    if (argc == 0) {
	usage();
    }
    strcpy(name, *argv);

    sts = check_device(name, device);
    if (sts < 0) {
	perror(program);
	exit(1);
    }

    sts = unmount_fs(name, err);
    if (sts < 0) {
	perror(err);
	exit(1);
    }

    sts = eject(device);
    if (sts < 0) {
	perror(program);
	exit(1);
    }

    exit(0);
}

int
check_device(name, device)
    char *name;
    char *device;
{
    int sts;
    struct stat sb;

    sprintf(device, "/dev/r%sc", name);
    sts = stat(device, &sb);

    return sts;
}

int
unmount_fs(name, err)
    char *name;
    char *err;
{
    int mnts;
    struct statfs *mntbuf;
    int len, i, n;
    char *p, *q;
    int sts, flag;

    mnts = getmntinfo(&mntbuf, MNT_NOWAIT);
    if (mnts == 0) {
	return -1;
    }
    len = strlen(name);
    for (n = 0; n < mnts; n++) {
	p = rindex(mntbuf[n].f_mntfromname, '/');
	if (p == NULL) {
	    continue;
	}
	for (i = 0, ++p, q = name; *p != '\0' && *q != '\0'; ++i, ++p, ++q) {
	    if (*p != *q) {
		break;
	    }
	}
	if (i == len) {
	    if (*p == '\0' || strchr("abcdefghs", *p) != NULL) {
		sync();
		flag = fflag ? MNT_FORCE : 0;
		sts = unmount(mntbuf[n].f_mntonname, flag);
		if (sts < 0 && fflag == 0) {
		    sprintf(err, "%s: %s", program, mntbuf[n].f_mntonname);
		    return sts;
		}
	    }
	}
    }

    return 0;
}

int
eject(device)
    char *device;
{
    int fd, sts;

    fd = open(device, O_RDONLY);
    if (fd < 0) {
	if (errno == ENXIO) {
	    /* No medium */
	    return 0;
	}
	return -1;
    }
    sts = ioctl(fd, CDIOCALLOW);
    if (sts >= 0) {
	sts = ioctl(fd, CDIOCEJECT);
    }
    close(fd);

    return sts;
}

void
usage(void)
{
    fprintf(stderr, "usage: %s [-f] device\n", program);
    exit(1);
}
