/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "tcl_interaction.h"
 *                                    created: 28/10/97 {2:04:50 pm} 
 *                                last update: 05/06/98 {16:03:30 PM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  28/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_tcl_interaction_
#define _Cpptcl_tcl_interaction_

#include "cpptclInt.h"
#include "cpptcl_type.h"
#include "meta_type.h"

class cpp_mem;
class cpptcl_metaobject;
class meta_object;
typedef cpptcl_metaobject* (*cpptcl_metaobject_fn)(tcl_args&, cpptcl_metaobject*);

class tcl_interaction;
class cpptcl_metaobject;

//@Section: Cpptcl library
//@Man:
DLL_IMPORT_EXPORT
class tcl_interaction {
  enum representation_types { CPPTCL_OBJ, CPPTCL_STRING, CPPTCL_CMDINFO };
  protected:
	/// This is either the Tcl command info, or the subcommand name if embedded
	union {
		 mutable Tcl_Obj* _name;
		 mutable const char * _char_name;
		Tcl_Command cmd_info_;
	};
  private:
    mutable representation_types _representation;
  public:
	/// return the name
	Tcl_Obj* name(void) const { 
	    if(_representation != CPPTCL_OBJ) {
	    	_name = Tcl_NewStringObj(_char_name,-1);
		Tcl_IncrRefCount(_name);
		_representation = CPPTCL_OBJ;
	    }
	    return _name;
	}
	/// this declares the object type, and two hidden fns 'type()', 'meta_info()'
	Cpptcl_BaseClass(tcl_interaction);
	///
	tcl_interaction(void):_name(0),_representation(CPPTCL_OBJ) {}
	///
	tcl_interaction(const tcl_interaction& c):_name(c._name),
	  _representation(c._representation) {
	    if(_representation == CPPTCL_OBJ && _name) {
	        Tcl_IncrRefCount(_name);
	    }
	}
	tcl_interaction(Tcl_Obj* n) {
		_name = n;
		if(_name) Tcl_IncrRefCount(_name);
		_representation = CPPTCL_OBJ;
	}
    ///
	tcl_interaction(const char* n) {
		_char_name = n;
		_representation = CPPTCL_STRING;
	}
	///
	virtual ~tcl_interaction(void) {
  	    if(_representation == CPPTCL_OBJ && _name) {
	        Tcl_DecrRefCount(_name);
	    }
	}
	///
	
	static DLL_IMPORT_EXPORT cpptcl_metaobject* metaobject;
	///
    virtual int parse_tcl_command(tcl_args& arg)=0;
	///
    virtual int parse_meta_commands(tcl_obj& o, tcl_args& arg);
	/// get our tcl command (could be an ensemble command)
	virtual tcl_obj& tcl_command(tcl_obj&) const=0;
    /// get our tcl stream
    virtual tcl_obj& get_tcl_obj(void) const=0;
	///
    virtual char* char_tcl_command(void) const {return "dummy";}
    ///
	virtual bool embedded(void) const=0;
	///
	int tcl_command_entry_point(tcl_args& arg);
	///
	virtual tcl_object* objcontainer(void) const=0;
	///
	bool has_members(void) const {return meta_info().has_members();}
	
};

//@Section: Cpptcl library
//@Man:
/// Write the object's command onto the tcl stream.
/**
 * This command could be a space separated ensemble command.  Note
 * that 'operator << pointer-to-object' is used to output an object's
 * command name.  We reserve 'operator << object' to output the
 * value of an object (mostly useful for members).
 */
tcl_obj& operator << (tcl_obj& o, const tcl_interaction* obj);

inline tcl_obj& operator << (tcl_obj& o, const tcl_interaction* obj) {
	return obj->tcl_command(o);
}

#endif
