#ifdef DEFINE_TEMPLATES

#include "olist.h"

////////////////////////////////////////////////////////////////////////
///										 IMPLEMENTATION	of olist												 ///

template<class T>	
void olist<T>::initToNulllist() {
	headPtr	=	NULL;
	tailPtr	=	NULL;
}

template<class T>	
olist<T>::olist()	{
	this->initToNulllist();
}

template<class T>	
olist<T>::olist	(T t1) {
	this->initToNulllist();
	this->append(t1);
}

template<class T>	
olist<T>::olist	(T t1, T t2) {
	this->initToNulllist();
	this->append(t1);
	this->append(t2);
}

template<class T>	
olist<T>::olist	(T t1, T t2, T t3) {
	this->initToNulllist();
	this->append(t1);
	this->append(t2);
	this->append(t3);
}

template<class T>	
olist<T>::olist	(T t1, T t2, T t3, T t4) {
	this->initToNulllist();
	this->append(t1);
	this->append(t2);
	this->append(t3);
	this->append(t4);
}


template<class T>
void olist<T>::reverseInPlace() {

	if (this->isEmpty()) return;

	olist_node<T> *now;
	olist_node<T> *temp;
 
	now	=	this->headPtr;

	while	(now !=	NULL)	{
		temp = now->next;
		now->next	=	now->prev;
		now->prev	=	temp;
		now	=	temp;
 }
			
	temp = this->headPtr;
	this->headPtr	=	this->tailPtr;
	this->tailPtr	=	temp;

}


// Creates a new olist, initialized by	the	first	n	elements of	array	at.	
template<class T>
olist<T>::olist(T	*at, int n)	
{
	int	i;
	
	this->initToNulllist();
	for	(i=0;	i<n; i++)	{
		this->append(at[i]);
	}	
}

// Allocates a new array whose elements	are	the	elements of	the	olist
// The caller	of toArray assumes responsibility	for	disposing	of the
//	 memory	obtained for the array.
// If	the	olist is	empty, NULL	is returned	and	no mem is	allocated.
// If	there	are	problems allocating	mem	or accessing the olist, 
//	 the function	exits	the	program.
template<class T>
T	*olist<T>::toArray()	const	
{
	T	*newArray;
	int	n	=	this->length();
	 int i;							
	olist_pos<T>	step = this->headConst();
	
	// If	olist is	empty	then bail
	if (n	== 0)	return NULL;
	
	if (!(newArray = new T[n]))	{
		//cerr <<	"olist.toArray: Unable	to allocate	array	of size	"	<< n <<	"\n";
		exit(1);
	}

		// Invariant:	Elements 0..i-1	of the olist	have been	inserted into	array
	for	(i=0;	i	<	n-1	;	step.goNext(), i++)	{
		 if	(step.onlist())	
			 newArray[i] = step.item();
			else {
			 //cerr	<< "olist.toArray:	Error	accessing	element	at olist	loc	"	<< i <<	"\n";
			 exit(1);
		 }
	}

	 //	We save	inserting	the	the	last element so	that we	can	do another simple
	 //	sanity check - namely	that we	are	truly	at the last	element	of the
	 //	olist.

	// Assert: elements	0..n-2 have	been added to	olist & n>0 
	if (step.atTail()	&& step.onlist())
		 newArray[n-1] = step.item();
	else {
		 //cerr	<< "olist.toArray:	Didn't reach end of	olist\n";
		 exit(1);
	}

	return newArray;
}

// Returns the length	of the olist
template<class T>
int	olist<T>::length()	const	{
 //	Currently, steps through whole olist	to find	length
 //	Could	cache	the	length in	an extra piece member	data if	this
 //	becomes	a	big	performance	hit	-	of course	that would add complexity
 //	to every other method	that modified	the	length of	olists...
	int	len	=	0;

	for	(olist_pos<T> step	=	this->headConst();
		 step.onlist();
		 len++,	step.goNext()) {
		 	/* empty loop body */
		 }
		 
	
	return len;
}

// Returns the value of	the	n'th element of	the	olist
template<class T>
T	olist<T>::nth_element(int n)	const	{
	// we	start	at 1
	n--;
	olist_pos<T>	step = this->headConst();

		for	(;step.onlist()	&& n;
		 n--,	step.goNext()) {
		 	/* empty loop body */
		 }
	
		return step.item();
}

// Returns the position	of 't' in	the	olist,	or -1	if not there
template<class T>
int	olist<T>::positionOf(const	T& t)	const	{
		int	count	=	1;
	for(olist_pos<T>	p	=	this->headConst(); p.onlist();p.goNext(),	count++) {
			if ( p.here()	== t ) return	count;
	}
	return -1;
}

// through(b)
//	 Returns a olist	starting at	this and going through b.
template<class T>
olist<T>	olist_pos<T>::through(const olist_pos<T> b)	const	{
	olist_pos<T>	a	=	*this;
	olist<T>	templist;

 
	// Make	sure a and b are on	the	olist
/*	if (!a.reallyOnlist()	|| !b.reallyOnlist())
		return templist;

	// Make	sure a is	before b
	else	if (!(a	== b)	|| !(a < b))
		return templist;
*/

	// Copy	all	elements from	a	to b into	the	new	olist
	do {
		templist.append(a.item());
		a.goNext();
	}	while	(!(a==b));

	templist.append(b.item());

	// Return	the	olist
	return templist;
}


template<class T>	
void olist<T>::trashlist()	{
	olist_node<T> *l	=	headPtr, *m;
	while	(l)	{
		m	=	l->next;
		delete l;
		l	=	m;
	}
}

template<class T>	
olist<T>::~olist() {
	this->trashlist(); 
}

template<class T>	
olist_node<T>*	olist<T>::allocNode(olist_node<T>	*prev, T t,	olist_node<T> *next)	{
	olist_node<T> *n	=	new	olist_node<T>(prev, t,	next);
	if (n	== NULL) {
		//cerr <<	"could not allocate	olist_node.	Shucks.\n";
		exit(1);
	}
	return n;
}

template<class T>	
void olist<T>::createFirstElement(T t)	{
	if (headPtr	!= NULL	|| tailPtr !=	NULL)	{
		//cerr <<	"Internal	olist error:	call to	createFirstElement on	non-null olist.";
		exit(1);
	}
	this->headPtr	=	this->tailPtr	=	this->allocNode(NULL,	t, NULL);
}

template<class T>	
void olist<T>::append(T t)	{
	if (this->isEmpty()) {
		this->createFirstElement(t);
	}	else {
		olist_node<T> *oldTail	=	this->tailPtr;		
		olist_node<T> *newTail	=	this->allocNode(this->tailPtr, t,	NULL);
		oldTail->next	=	newTail;
		this->tailPtr		=	newTail;
	}
}



//----------------------------------------------------
//----------------------------------------------------
template<class T>
void olist<T>::remove(T t)	{
 
	 if	(this->isEmpty())	return;	
	 
	 olist_node<T>	*now = headPtr;

	 while ( (now	!= NULL) &&	(now->t	!= t)) {
		 now = now->next;
	 }
	 assert(now->t==t);
	 if	(now->t==t)	{
		 olist_node<T>	*pr	=	now->prev;
		 olist_node<T>	*ne	=	now->next;
		 if	(now ==	headPtr)
			 headPtr = ne;
		 else
			 pr->next	=	ne;
		 if	(now ==	tailPtr)
			 tailPtr = pr;
		 else
			 ne->prev	=	pr;
		 delete	now;
	} 
}

template<class T>
olist_pos<T>	olist<T>::head()	 {
	return olist_pos<T>(	this,	 this->headPtr,	false);
}

template<class T>
olist_pos<T>	olist<T>::headConst() const {
	return olist_pos<T>(	(olist<T>*	)	this,	(olist_node<T>*)this->headPtr,	true);
	// Need	to cast	away const-ness	to get this	to typecheck.
	// olist_pos's	look non-const to	the	compiler;
	// we've hacked	an extra field so	that calling const functions
	// on	non-const	objects	blows	up,	but	the	compiler
	// doesn't know	that.	
}

template<class T>
olist_pos<T>	olist<T>::tail()	 {
	return olist_pos<T>(	this,	 this->tailPtr,	false);
}

template<class T>
olist_pos<T>	olist<T>::tailConst() const {
	return olist_pos<T>(	(olist<T>*) this, (olist_node<T>*) this->tailPtr,	true);
	// Need	to cast	away const-ness	to get this	to typecheck.

}

#if (TCL_MAJOR_VERSION < 8)
template<class T>
ostream& operator<<(ostream& o,	const	olist<T>& l)	{
	o	<< "olist{" ;
	for(olist_node<T> *ln = l.headPtr;
			ln;
			ln=ln->next) {
		o	<< ln->t <<	(ln->next	?	"	"	:	"");
	}
	o	<< "}";
	return o;
}
#endif

template<class T>
void olist<T>::copyToNullFrom(const olist<T>&	l) {
	olist_pos<T>	tp = this->head();
	for( olist_pos<T> lp	=	l.headConst(); lp.onlist();	lp.goNext()) {
		tp.insertNext( lp.here() );
	}
}

template<class T>
olist<T>::olist(const	olist<T>& l)	{
	this->initToNulllist();
	this->copyToNullFrom(l);
}
	
template<class T>
olist<T>& olist<T>::operator=(const	olist<T>& l)	{
	if ( this	!= &l	)	{
		this->trashlist();
		this->initToNulllist();
		this->copyToNullFrom(l);
	}
	return *this;
}

template<class T>
olist<T>	olist<T>::operator+(const olist<T>&	lt)	const	{
	olist<T>	newThis	=	*this;
	olist<T>	newLT		=	lt;
	newThis.appendAndDestroy(newLT);
	return newThis;
}
template <class T>	
olist<T>& olist<T>::operator+=(const olist<T>& lt) {
	olist<T>& newLT = lt._copy_me();
	appendAndDestroy(newLT);
	return *this;
}

template<class T>   
olist<T>& olist<T>::_copy_me(void) const {
	olist<T>* l = new olist<T>(*this);
	return *l;
}

template<class T>
void olist<T>::appendAndDestroy(olist<T>&	lt)	{
	if(lt.isEmpty()) return;
	if(this->isEmpty())	{
		this->headPtr	=	lt.headPtr;
		this->tailPtr	=	lt.tailPtr;
		lt.headPtr		=	NULL;
		lt.tailPtr		=	NULL;
	}	else {
		olist_node<T> *thisTail = this->tailPtr;
		olist_node<T> *ltHead	 =	 lt.headPtr;
		thisTail->next = ltHead;
		ltHead->prev	 = thisTail;
		this->tailPtr	 = lt.tailPtr;
		lt.headPtr		=	NULL;
		lt.tailPtr		=	NULL;
	}
}

template<class T>
bool olist<T>::contains(const T& t) const {
	for(olist_pos<T>	p = this->headConst(); p.onlist(); p.goNext()) {
		if ( p.here() == t ) return true;
	}
	return false;
}

////////////////////////////////////////////////////////////////////////
//							IMPLEMENTATION of	olist_pos														 //

template <class	T>
olist_pos<T>::~olist_pos(void) {
}

// added VMD 31st	Jan	1995
template<class T>
olist_pos<T>::olist_pos(olist<T>& l)	 {
	this->cursor = l.headPtr;
	this->tolist = &l;
	this->isConstPos = false;
}

template<class T>
olist_pos<T>::olist_pos(const	olist<T>& l)	 {
	this->cursor = l.headPtr;
	this->tolist = (olist<T>*)	&l;
	this->isConstPos = true;

}

template<class T>
olist_pos<T>::olist_pos(olist<T>	*l,	olist_node<T> * n,	bool consty) {
	this->cursor = n;
	this->tolist = l;
	this->isConstPos = consty;
}

template<class T>
olist_pos<T>::olist_pos(const	olist_pos<T>& lp) {
	this->cursor = lp.cursor;
	this->tolist = lp.tolist;
	this->isConstPos = lp.isConstPos;
}

template<class T>
olist_pos<T>& olist_pos<T>::operator=(const	olist_pos<T>	&lp) {
	if (this !=	&lp) {
		this->cursor = lp.cursor;
		this->tolist = lp.tolist;
		this->isConstPos = lp.isConstPos;
	}
	return *this;
}

//*******************************************************
template<class T>
bool olist_pos<T>::operator<(const	olist_pos<T>& b)	const	{
	olist_pos<T>	step = *this;

	if ((b.reallyOnlist()	&& (this->reallyOnlist())))	{
	while	(step.onlist())	{
		step.goNext();
		if (step.cursor	== b.cursor) {
			return true;
		}
	}
	}
	return false;
}

template<class T>
bool olist_pos<T>::operator==(const olist_pos<T>&	b) const {

/*
	 cout	<< "Testing	lp equals\n";

	 cout	<< this->cursor	<< "	$	 " <<	b.cursor <<	"\n";	
*/
	 return	(this->cursor	== b.cursor ? true : false);	
}


template<class T>
T	olist_pos<T>::here()	const	{
	assert(!(this->offlist()));
	return this->cursor->t;
}

template<class T>
void olist_pos<T>::insertNext(T t)	{
	assert(!( this->isConst() ));
	if ( this->mylist()->isEmpty() ) {
		this->mylist()->createFirstElement(t);
		this->cursor = this->mylist()->headPtr;
		return;
	}	else if	(	this->offlist()) {
		assert(0);
	}	else {
		olist_node<T> *oldPrev	=	this->cursor;
		olist_node<T> *oldNext	=	this->cursor->next;
		olist_node<T> *newNode	=	this->mylist()->allocNode(oldPrev, t,	oldNext);
		oldPrev->next	=	newNode;
		if(oldNext)	oldNext->prev	=	newNode;
		if(oldPrev ==	this->mylist()->tailPtr) this->mylist()->tailPtr = newNode;
		cursor = newNode;
	}
}

template<class T>
void olist_pos<T>::insertPrev(T t)	{
	assert(!( this->isConst() ));
	//cerr <<	"Attempt to	insert into	a	const	olist.\n";
	if (this->mylist()->isEmpty()	)	{
		this->mylist()->createFirstElement(t);
		this->cursor = this->mylist()->tailPtr;
	}	else if	(this->offlist())	{
		//cerr <<	"Attempt to	insert past	the	end	of a olist\n";
		exit(1);
	}	else {
		olist_node<T> *oldPrev	=	this->cursor->prev;
		olist_node<T> *oldNext	=	this->cursor;
		olist_node<T> *newNode	=	this->mylist()->allocNode(oldPrev, t,	oldNext);
		oldNext->prev	=	newNode;
		if(oldPrev)	oldPrev->next	=	newNode;
		if(oldNext ==	this->mylist()->headPtr) this->mylist()->headPtr = newNode;
		cursor = newNode;
	}
}



template<class T>
bool olist_pos<T>::atHead() const {
	return (this->mylist()->headPtr	== this->cursor	?	true : false);
}

template<class T>
bool olist_pos<T>::atTail() const {
		return (this->mylist()->tailPtr	== this->cursor	?	true : false);
}

template<class T>
void olist_pos<T>::goNext(){
	if (this->onlist())	this->cursor = this->cursor->next;
}

template<class T>
void olist_pos<T>::goPrev(){
	if (this->onlist())	this->cursor = this->cursor->prev;
}

// Returns 1 if	the	olist_pos is	actually on	the	olist it	thinks it	is.
template <class	T>
bool olist_pos<T>::reallyOnlist() const {
	olist_pos<T>	b	=	this->mylist()->headConst();


	if (!this->onlist()) return	false;

	while	(b.onlist()) {
		if (b	== *this)	{
			return true;
		}
		b.goNext();
	}

	return false;
}

template<class T>
void olist_pos<T>::delete0()	{
	if (this->offlist()	|| this->isConstPos) 
		return;
	olist_node<T> * pre = this->cursor->prev;
	olist_node<T> * nex = this->cursor->next;
	if (this->mylist()->headPtr	== this->cursor) {
	 	// Deleting	first	element	of olist...
			this->mylist()->headPtr	=	nex;
	}	else {
			pre->next	=	nex;
	}
	if (this->mylist()->tailPtr	== this->cursor) {
			// Deleting	last element of	olist.
			// Note	that we	might	also be	deleting the first (=only) element too...
			this->mylist()->tailPtr	=	pre;
	}	else {
			nex->prev	=	pre;
	}
	
	delete this->cursor;
	this->cursor = NULL;
}

template<class T>
void olist_pos<T>::deleteAndGoNext()	{
		olist_pos<T>	n	=	*this;
		n.goNext();
		this->delete0();
		*this	=	n;
}

template<class T>
void olist_pos<T>::replaceWith(T	t) {
		if (this->offlist()	|| this->isConstPos) {
			//cerr <<	"Cannot	replace	olist element";
			exit(1);
		}
		this->cursor->t	=	t;
}

////////////////////////////////////////////////////////////////////////

#endif
